ORCA/M Asm65816 2.1.0

0001 13FE                       title 'Tool Locator--Tool Loading'
0002 13FE              ****************************************************************
0003 13FE              *                                                              *
0004 13FE              *                     Tool Loading                             *
0005 13FE              *                                                              *
0006 13FE              ****************************************************************
0007 13FE
0008 13FE
0009 13FE              ****************************************************************
0010 13FE              *                                                              *
0011 13FE              *                  Copyright (C) 1985-1989                     *
0012 13FE              *                  All Rights Reserved                         *
0013 13FE              *                  Apple Computer, Inc.                        *
0014 13FE              *                                                              *
0015 13FE              ****************************************************************
0016 13FE
0017 13FE              **********************************************************************
0018 13FE              *
0019 13FE              * Change History
0020 13FE              *
0021 13FE              * 15 Mar 89        Steven Glass
0022 13FE              *
0023 13FE              * UnloadThisTool no longer can cause a system death.  It used to
0024 13FE              * die on unexpected loader errors.  There are now just ignored.
0025 13FE              *
0026 13FE              * 07 Apr 89        Steven Glass
0027 13FE              *
0028 13FE              * Added range check to UnloadThisTool
0029 13FE              *
0030 13FE              * 4/6/90           Mensch
0031 13FE              * Fixed range check in UnloadThisTool it will now correctly test the
0032 13FE              * current TPT.
0033 13FE              *
0034 13FE              * 18-Nov-90        Dave Lyons
0035 13FE              *
0036 13FE              * Changed CheckVersion to reflect new definition of version bits 14-12.
0037 13FE              * These flag special things about the tool version.
0038 13FE              *
0039 13FE              * 3-Dec-91         Dave Lyons
0040 13FE              *
0041 13FE              * Changed LoadThisTool to always prompt for boot disk (state of Cancel
0042 13FE              * button is not forced).
0043 13FE              *
0044 13FE              * 16-Dec-91        Dave Lyons
0045 13FE              *
0046 13FE              * Fixed capitalization of StartChars string (*/System/Tools/Tool),
0047 13FE              * since the Loader now makes the original capitalization visible
0048 13FE              * through LGetPathname[2].
0049 13FE              *
0050 13FE              * Added ReportIfMissing to LoadTools, to tell user what tool they
0051 13FE              * need to install.
0052 13FE              *
0053 13FE              * 17-Dec-91        Dave Lyons
0054 13FE              *
0055 13FE              * Changed Quit to Continue in ReportIfMissing.
0056 13FE              *
0057 13FE              **********************************************************************
0058 13FE              *
0059 13FE              * 7-Jul-92         Dave Lyons for 6.0.1
0060 13FE              *
0061 13FE              * Changed ReportIfMissing to never complain that a tool that is
0062 13FE              * present is missing just because the version is too low.
0063 13FE              *
0064 13FE              **********************************************************************
0065 13FE
0066 13FE                       blanks off 
0067 13FE                       string asis 
0068 13FE
0069 13FE                       print push 
0070 13FE                       print off 
0071 13FE                       include 'all.macros' 
0072 13FE                       include '::sys.equs.asm' 
0073 13FE                       INCLUDE 'e16.memory' 
0074 13FE
0075 13FE                       include 'tl.equates.asm' 
0076 13FE                       print pop 
0077 13FE
0078 13FE
0079 13FE
0080 13FE
0081 13FE                       title ' Imported Addresses' 
0082 13FE              ;-----------------------------------------------
0083 13FE              ;
0084 13FE              ;   Imported addresses
0085 13FE              ;
0086 13FE              ;-----------------------------------------------
0087 13FE
0088 13FE                       IMPORT BusyErr4 
0089 13FE
0090 13FE                       eject 
0091 13FE              ****************************************************************
0092 13FE              *
0093 13FE              LoadTools PROC EXPORT 
0094 13FE              *
0095 13FE              *         Pointer to ToolTable
0096 13FE              *
0097 13FE              * where ToolTable looks
0098 13FE              *
0099 13FE              *              dc i'NumTools'
0100 13FE              *              dc i'ToolNum1,MinVersion1'
0101 13FE              *              dc i'ToolNum2,MinVersion2'
0102 13FE              *              .
0103 13FE              *              .
0104 13FE              *              .
0105 13FE              *
0106 13FE              *
0107 13FE              * The tools are kept in the subdirectory TOOLS in the system
0108 13FE              * subdirectory with the following naming convention:
0109 13FE              *
0110 13FE              *          Tool015   for tool set 15
0111 13FE              *          Tool023   for tool set 23
0112 13FE              *
0113 13FE              * etc.
0114 13FE              *
0115 13FE              * Tools 1 through 13 are in ROM.  The only parts of them that
0116 13FE              * will be in RAM are not loaded in this way but are part of the
0117 13FE              * patch mechanism.
0118 13FE              *
0119 13FE              *
0120 13FE              *
0121 13FE              *
0122 13FE              * Inputs:
0123 13FE              *	ToolTablePtr : Long
0124 13FE              *
0125 13FE              * Outputs:
0126 13FE              *	none
0127 13FE              *
0128 13FE              * External Refs:
0129 13FE                       import GetSpecialFlag 
0130 13FE                       import LoadThisTool 
0131 13FE                       import ReportIfMissing         ;16-Dec-91 DAL
0132 13FE              *
0133 13FE              * Entry Points:
0134 13FE              *	none
0135 13FE              *
0136 13FE                       longa on                       ; mode
0137 13FE                       longi on
0138 13FE              *
0139 13FE              * Change History
0140 13FE              *
0141 13FE              * 05 Oct 87    Steven Glass
0142 13FE              *
0143 13FE              *    Changes were made to this call to accomdate new calling
0144 13FE              *    structure for LoadThisTool.  Additionally, changes were
0145 13FE              *    made to get rid of the special memory global variable.
0146 13FE              *
0147 13FE              *    Finally, this call was adjusted to use the new exit
0148 13FE              *    routines.
0149 13FE              *
0150 13FE              ****************************************************************
0151 13FE
0152 13FE
0153 13FE                       DefineStack 
0154 13FE              Counter  word 
0155 13FE              SpecialFlag word 
0156 13FE              CurPtr   long 
0157 13FE              OrigD    word 
0158 13FE              RTL1     block 3 
0159 13FE              RTL2     block 3 
0160 13FE              ToolTablePtr long 
0161 13FE
0162 13FE 0B                    phd                            ; save direct
0163 13FF A9 00 00              lda   #0                       ; put eight extra bytes on stack
0164 1402 48                    pha                            ; (all zeros)
0165 1403 48                    pha   
0166 1404 48                    pha   
0167 1405 48                    pha   
0168 1406 3B                    tsc                            ; get stack
0169 1407 5B                    tcd                            ; set stack to zp
0170 1408
0171 1408 22 64 00 E1           jsl   IncBusyFlg
0172 140C
0173 140C 8B                    phb                            ; save and set data bank
0174 140D 4B                    phk   
0175 140E AB                    plb   
0176 140F
0177 140F 20 6B 1A              jsr   GetSpecialFlag           ; init the special flag.
0178 1412 85 03                 sta   SpecialFlag
0179 1414
0180 1414 A5 11                 lda   ToolTablePtr             ; init CurPtr
0181 1416 18                    clc   
0182 1417 69 02 00              adc   #2
0183 141A 85 05                 sta   CurPtr
0184 141C A5 13                 lda   ToolTablePtr+2
0185 141E 69 00 00              adc   #0
0186 1421 85 07                 sta   CurPtr+2
0187 1423
0188 1423 A5 01        Loop     lda   Counter                  ; test counter to see if we are
0189 1425 C7 11                 cmp   [ToolTablePtr]           ; done.
0190 1427 B0 27                 bcs   AllDone
0191 1429
0192 1429
0193 1429 48                    pha                            ; space for result
0194 142A A7 05                 lda   [CurPtr]                 ; Push Tool Number
0195 142C 48                    pha   
0196 142D A0 02 00              ldy   #2                       ; Push min version from table
0197 1430 B7 05                 lda   [CurPtr],y               ; 
0198 1432 48                    pha   
0199 1433 D4 03                 pei   SpecialFlag
0200 1435 20 93 1A              jsr   LoadThisTool             ; get it loaded
0201 1438 FA                    plx   
0202 1439 86 03                 stx   SpecialFlag
0203 143B B0 16                 bcs   ErrorOut                 ; if error occured, quit.
0204 143D
0205 143D A5 05                 lda   CurPtr                   ; bump pointer into table
0206 143F 18                    clc   
0207 1440 69 04 00              adc   #4
0208 1443 85 05                 sta   CurPtr
0209 1445 A5 07                 lda   CurPtr+2
0210 1447 69 00 00              adc   #0
0211 144A 85 07                 sta   CurPtr+2
0212 144C
0213 144C E6 01                 inc   Counter                  ; bump counter
0214 144E 80 D3                 bra   Loop
0215 1450
0216 1450              AllDone                                 ; 
0217 1450 A9 00 00              lda   #0                       ; signal no error and fall into
0218 1453              ;                                       ; error out routine
0219 1453
0220 1453              ErrorOut  
0221 1453 AB                    plb                            ; restore DBR
0222 1454 AA                    tax   
0223 1455              *** added 16-Dec-91 DAL -- put up a nice missing-tool dialog
0224 1455 A7 05                 lda   [CurPtr]
0225 1457 20 62 19              jsr   ReportIfMissing
0226 145A              *** end 16-Dec-91
0227 145A
0228 145A 7A                    ply                            ; clean up the stack
0229 145B 7A                    ply   
0230 145C 7A                    ply   
0231 145D 7A                    ply   
0232 145E 5C 48 1D 02           jml   BusyErr4
0233 1462
0234 1462                       ENDP 
0235 1462
0236 1462
0237 1462              ****************************************************************
0238 1462              *
0239 1462              * ReportIfMissing -- new routine 16-Dec-91 DAL for 6.0d62
0240 1462              *
0241 1462              * Input: A = tool number, X = error code
0242 1462              *
0243 1462              * Registers are preserved.
0244 1462              *
0245 1462              ****************************************************************
0246 1462              ReportIfMissing proc export 
0247 1462
0248 1462 E0 46 00              cpx   #$0046                   ;file not found?
0249 1465 D0 6B                 bne   @noMessage
0250 1467
0251 1467 48                    pha   
0252 1468 DA                    phx   
0253 1469 5A                    phy   
0254 146A
0255 146A              *** added 7-Jul-92 DAL -- Don't complain that a loaded tool is missing just
0256 146A              ***                       because the version is too low.
0257 146A A3 05                 lda   5,s                      ;tool number
0258 146C 09 00 04              ora   #$0400                   ;xxxVersion
0259 146F AA                    tax   
0260 1470 48                    pha                            ;space for result
0261 1471 22 00 00 E1           jsl   $e10000
0262 1475 68                    pla                            ;discard result
0263 1476 90 57                 bcc   @noMsg
0264 1478
0265 1478 A3 05                 lda   5,s
0266 147A              *** end 7-Jul-92
0267 147A
0268 147A 48                    pha                            ;tool # for Int2Dec
0269 147B F4 02 00 F4           pushlong #toolNumTxt 
0270 1481 F4 03 00              pea   3                        ;3 character length
0271 1484 F4 00 00              pea   0                        ;unsigned
0272 1487 A2 0B 26 22           _Int2Dec 
0273 148E
0274 148E E2 20                 sep   #$20
0275 1490                       longa off
0276 1490 AF EF 19 02           lda   >toolNumTxt+0
0277 1494 C9 20                 cmp   #$20                     ;blank
0278 1496 D0 06                 bne   @notBlank1
0279 1498 A9 30                 lda   #$30                     ;zero
0280 149A 8F EF 19 02           sta   >toolNumTxt+0
0281 149E AF F0 19 02  @notBlank1 lda   >toolNumTxt+1
0282 14A2 C9 20                 cmp   #$20                     ;blank
0283 14A4 D0 06                 bne   @notBlank2
0284 14A6 A9 30                 lda   #$30                     ;zero
0285 14A8 8F F0 19 02           sta   >toolNumTxt+1
0286 14AC C2 20        @notBlank2 rep   #$20
0287 14AE                       longa on
0288 14AE
0289 14AE 48                    pha                            ;space for TLTextMountVol result
0290 14AF F4 02 00 F4           pushlong #missingLine1 
0291 14B5 F4 02 00 F4           pushlong #missingLine2 
0292 14BB F4 02 00 F4           pushlong #nullText 
0293 14C1 F4 02 00 F4           pushlong #OKStrText 
0294 14C7 A2 01 12 22           _TLTextMountVolume 
0295 14CE 68                    pla                            ;discard result
0296 14CF
0297 14CF 7A           @noMsg   ply   
0298 14D0 FA                    plx   
0299 14D1 68                    pla   
0300 14D2 60           @noMessage rts   
0301 14D3
0302 14D3 1E 54 68 69  missingLine1 DC B:30,'This application needs Tool'
0303 14EF 30 30 30     toolNumTxt DC B:'000'
0304 14F2 1B 69 6E 20  missingLine2 DC B:27,'in the System:Tools folder.'
0305 150E
0306 150E              ; text OK button string for TLTextMountVolume
0307 150E              ; spaces push Button2 (left button) to the right (to right-justify it)
0308 150E              ;   (can’t be Button1 because escape chars are counted in Button1’s right justification!)
0309 150E              ; $1B: ESC to enable mousetext in the firmware
0310 150E              ; $0F: turns on Inverse
0311 150E              ; ‘M’ is mousetext for return char
0312 150E              ; $0E: turns off inverse
0313 150E              ; $18: Ctrl-X to disable mousetext in the firmware
0314 150E 25 20 20 20  OKStrText DC B:EndOKStrText-*-1,'                       Continue '
0315 152F 0F 1B 4D 0E           DC B:$0f,$1b,'M',$0E,$18
0316 1534              EndOKStrText  
0317 1534
0318 1534 00           nullText DC B:0
0319 1535
0320 1535                       EndP 
0321 1535
0322 1535
0323 1535                       title 'LoadOneTool' 
0324 1535              ****************************************************************
0325 1535              *
0326 1535              LoadOneTool PROC EXPORT 
0327 1535              *
0328 1535              * Assures that the specified tool is available and has a version 
0329 1535              * number equal to or greater than MinVersion.  If the tool is not
0330 1535              * loaded when the call is made it trys to load the tool from disk.
0331 1535              *
0332 1535              * If the tool is not on disk or the required version is not available
0333 1535              * errors are returned.
0334 1535              *
0335 1535              *
0336 1535              * Inputs:
0337 1535              *         ToolNumber : word
0338 1535              *         MinVersion : word
0339 1535              *
0340 1535              * Outputs:
0341 1535              *	none
0342 1535              *
0343 1535              * External Refs:
0344 1535                       import GetSpecialFlag 
0345 1535                       import LoadThisTool 
0346 1535              *
0347 1535              * Entry Points:
0348 1535              *	none
0349 1535              *
0350 1535                       longa on                       ; mode
0351 1535                       longi on
0352 1535              *
0353 1535              *
0354 1535              * Change History
0355 1535              *
0356 1535              *   05 Nov 86   SEG    The Stack equates were off by one.  The
0357 1535              *                      data bank register was not accounted for.
0358 1535              *
0359 1535              *   05 Oct 87   SEG    Uses direct page addressing instead of 
0360 1535              *                      stack.
0361 1535              *
0362 1535              *                      Uses new format of LoadThisTool call.
0363 1535              *
0364 1535              *                      Uses new exit routines.
0365 1535              *
0366 1535              *   14 Oct 87   SEG    Extra D-reg no longer left on stack.
0367 1535              *
0368 1535              ****************************************************************
0369 1535
0370 1535
0371 1535                       DefineStack 
0372 1535              OrigD    word 
0373 1535              RTL1     block 3 
0374 1535              RTL2     block 3 
0375 1535              MinVersion word 
0376 1535              ToolNumber word 
0377 1535
0378 1535 0B                    phd                            ; save direct
0379 1536 3B                    tsc                            ; get stack
0380 1537 5B                    tcd                            ; set stack to zp
0381 1538
0382 1538 22 64 00 E1           jsl   IncBusyFlg
0383 153C
0384 153C 8B                    phb   
0385 153D 4B                    phk   
0386 153E AB                    plb   
0387 153F
0388 153F 48                    pha                            ; space for result
0389 1540 D4 0B                 pei   ToolNumber
0390 1542 D4 09                 pei   MinVersion
0391 1544 20 6B 1A              jsr   GetSpecialFlag
0392 1547 48                    pha   
0393 1548 20 93 1A              jsr   LoadThisTool             ; get it loaded
0394 154B
0395 154B FA                    plx                            ; ignore the result
0396 154C
0397 154C AB                    plb                            ; restore dbr
0398 154D
0399 154D AA                    tax                            ; error code in x
0400 154E 5C 48 1D 02           jml   BusyErr4
0401 1552
0402 1552                       ENDP 
0403 1552
0404 1552
0405 1552                       title 'UnloadOneTool' 
0406 1552              ****************************************************************
0407 1552              *
0408 1552              UnLoadOneTool PROC EXPORT 
0409 1552              *
0410 1552              * Unloads the specified tool in the following way:  If it was
0411 1552              * loaded from disk it calls the Loader to put it in zombie state
0412 1552              * and installs a dummy tool table for the specified tool.
0413 1552              *
0414 1552              * If the tool was not loaded from disk, this proc does nothing.
0415 1552              *
0416 1552              *
0417 1552              * Inputs:
0418 1552              *                   ToolNumber : integer
0419 1552              *
0420 1552              * Outputs:
0421 1552              *                   none
0422 1552              *
0423 1552              * External Refs:
0424 1552                       import SetupForUnload 
0425 1552                       import CleanupForUnload 
0426 1552                       import UnloadThisTool 
0427 1552              *
0428 1552              * Entry Points:
0429 1552              *	none
0430 1552              *
0431 1552                       longa on                       ; mode
0432 1552                       longi on
0433 1552              *
0434 1552              * Change History
0435 1552              *
0436 1552              * 05 Oct 87    Steven Glass
0437 1552              *
0438 1552              *    This call was adjusted to use the new exit routines.
0439 1552              *
0440 1552              *    No changes were need to make this run in ROM.  Many changes
0441 1552              *    were made however to adjust this to the new tool loading
0442 1552              *    algorithm.  
0443 1552              *
0444 1552              ****************************************************************
0445 1552
0446 1552
0447 1552
0448 1552              RTL1     equ 1 
0449 1552              RTL2     equ RTL1+3 
0450 1552              ToolNumber equ RTL2+3 
0451 1552
0452 1552
0453 1552 22 64 00 E1           jsl   IncBusyFlg
0454 1556
0455 1556 A3 07                 lda   ToolNumber,s
0456 1558
0457 1558
0458 1558                       DefineStack 
0459 1558              OrigD    word 
0460 1558              RealTPT  long 
0461 1558              DefaultTPT long 
0462 1558              Counter  word 
0463 1558
0464 1558 20 A3 1C              jsr   SetupforUnload           ; preserves a-reg
0465 155B
0466 155B 85 0B                 sta   Counter
0467 155D
0468 155D 20 44 1C              jsr   UnloadThisTool
0469 1560
0470 1560 20 C8 1C              jsr   CleanupForUnload
0471 1563
0472 1563 AA                    tax   
0473 1564
0474 1564 A0 02 00              ldy   #2
0475 1567 5C 80 01 E1           jml   ToBusyStrip
0476 156B
0477 156B                       ENDP 
0478 156B
0479 156B
0480 156B                       title 'GetSpecialFlag' 
0481 156B              ****************************************************************
0482 156B              *
0483 156B              GetSpecialFlag PROC 
0484 156B              *
0485 156B              * Returns value of SpecialMemory flag in a-reg.
0486 156B              *
0487 156B              *
0488 156B              * Inputs:
0489 156B              *                   none
0490 156B              *
0491 156B              * Outputs:
0492 156B              *                   none
0493 156B              *
0494 156B              * External Refs:
0495 156B              *                   none
0496 156B              *
0497 156B              * Entry Points:
0498 156B              *                   none
0499 156B              *
0500 156B                       longa on                       ; mode
0501 156B                       longi on
0502 156B              *
0503 156B              * Change History
0504 156B              *
0505 156B              * 05 Oct 87    Steven Glass
0506 156B              *
0507 156B              *    This call no longer sets a global variable, but rather
0508 156B              *    returns with the value fo that variable in the a-reg.
0509 156B              *
0510 156B              *    The name of this routine was changed from SetSpecialFlag
0511 156B              *    to GetSpecialFlag.
0512 156B              *
0513 156B              ****************************************************************
0514 156B
0515 156B
0516 156B 48                    pha   
0517 156C 48                    pha   
0518 156D A2 02 1D 22           _TotalMem 
0519 1574 68                    pla   
0520 1575 68                    pla   
0521 1576 C9 04 00              cmp   #^256*1024
0522 1579 F0 14                 beq   BaseMachine
0523 157B
0524 157B 48                    pha   
0525 157C 48                    pha   
0526 157D A2 02 1B 22           _FreeMem 
0527 1584 68                    pla   
0528 1585 68                    pla   
0529 1586 C9 03 00              cmp   #^200*1024
0530 1589 90 04                 bcc   NotEnough
0531 158B
0532 158B A9 00 80              lda   #$8000
0533 158E 60                    rts   
0534 158F
0535 158F              NotEnough                               ; 
0536 158F              BaseMachine                             ; 
0537 158F A9 00 00              lda   #0
0538 1592 60                    rts   
0539 1593
0540 1593
0541 1593                       ENDP 
0542 1593
0543 1593
0544 1593                       title 'LoadThisTool' 
0545 1593              ****************************************************************
0546 1593              *
0547 1593              LoadThisTool PROC 
0548 1593              *
0549 1593              *
0550 1593              * Loads the tool, installs it, checks its version number 
0551 1593              * against the min required.
0552 1593              *
0553 1593              * How its done
0554 1593              *
0555 1593              *     Version is checked for desired tool.  If the currently installed
0556 1593              *     tool has a good enough version number, we are done.  If the version 
0557 1593              *     number is bad or the tool is not installed we try and load
0558 1593              *     the tool from disk as follows:
0559 1593              *
0560 1593              *       First try a restart in case the tool is alread in memory.  If this
0561 1593              *       works, install the tool, do the version check and quit
0562 1593              *
0563 1593              *       If the tool cannot be restarted, create the pathname 
0564 1593              *       of the the tool to load.
0565 1593              *
0566 1593              *       Use the specialFlag to decide how to load the tool (special
0567 1593              *       mem or not).  If a non special mem load fails, try again in 
0568 1593              *       special.
0569 1593              *
0570 1593              *       Install the TPT that is at the start of the load file.
0571 1593              *
0572 1593              *       Verify the version number.
0573 1593              *
0574 1593              *     Many different errors can be returned:
0575 1593              *
0576 1593              *       Any loader errors including volume not found and not enough memory.
0577 1593              *       The version error can also be returned.
0578 1593              *
0579 1593              *
0580 1593              *
0581 1593              * Inputs:
0582 1593              *     ToolNumber              : word
0583 1593              *     MinVersion              : word
0584 1593              *     SpecialFlag             : word
0585 1593              *
0586 1593              * Outputs:
0587 1593              *     NewValue of SpecialFlag  : word
0588 1593              *
0589 1593              * External Refs:
0590 1593                       import TLGetMem 
0591 1593                       import MakeIDNum 
0592 1593              *
0593 1593              * Entry Points:
0594 1593              *	none
0595 1593              *
0596 1593                       longa on                       ; mode
0597 1593                       longi on
0598 1593              *
0599 1593              * Change History
0600 1593              *
0601 1593              * 29 January 87    Steven Glass
0602 1593              *
0603 1593              *    When a prodos error occured I was comparing the error code to $0201
0604 1593              *    (memfull).  When not equal I was trying to exit with error code in
0605 1593              *    A-reg but compare cleared carry causing all sorts of grief.
0606 1593              *
0607 1593              *
0608 1593              * 05 Oct 87    Steven Glass
0609 1593              *
0610 1593              *    Adjustments were necessary to run out of ROM.
0611 1593              *    This routine now has inputs and outputs on the stack.  It
0612 1593              *    does not use inline data storage.
0613 1593              *
0614 1593              *    Version checking is now in-line rather than a subroutine
0615 1593              *    call.  This made it possible to share local variables
0616 1593              *    and since no other routine was using this code, it saved
0617 1593              *    the JSR/RTS.
0618 1593              *
0619 1593              *    MakeToolPath is now part of this routine.  It was never
0620 1593              *    called by any other routine and making it part of this
0621 1593              *    routine makes it easier to share local data.
0622 1593              *
0623 1593              *    The tool path name is now created in a handle rather than
0624 1593              *    in line.  The handle is obtained by MakeToolPath and
0625 1593              *    disposed of during clean up.
0626 1593              *
0627 1593              ****************************************************************
0628 1593
0629 1593
0630 1593                       DefineStack 
0631 1593              PathHandle long 
0632 1593              PathPtr  long 
0633 1593              OrigD    word 
0634 1593              RTSAdr   word 
0635 1593              TheSpecialFlag word 
0636 1593              TheMinVersion word 
0637 1593              TheToolNumber word 
0638 1593              ResultSpecialFlag word 
0639 1593
0640 1593
0641 1593              ;---------------------------------------------------
0642 1593              ;
0643 1593              ; Save, direct reg, get space for locals and 
0644 1593              ; turn stack into direct page.
0645 1593              ;
0646 1593
0647 1593 0B                    phd                            ; save direct
0648 1594 A9 00 00              lda   #0                       ; put zeros on stack
0649 1597 48                    pha                            ; for path handle and
0650 1598 48                    pha                            ; ptr
0651 1599 48                    pha   
0652 159A 48                    pha   
0653 159B 3B                    tsc                            ; turn stack into 
0654 159C 5B                    tcd                            ; direct page
0655 159D
0656 159D              ;---------------------------------------------------
0657 159D              ;
0658 159D              ; Check to see if this is a tool we have to load.
0659 159D              ; If the version number checks out then there is
0660 159D              ; nothing else to do.  If the version does not
0661 159D              ; check out, then try to load it from the 
0662 159D              ; system disk.
0663 159D              ;
0664 159D 20 76 1B              jsr   CheckVersion
0665 15A0              ;;;	bcc	FastExit
0666 15A0 B0 03                 bcs   @noFastExit
0667 15A2 82 84 00              brl   FastExit
0668 15A5              @noFastExit  
0669 15A5
0670 15A5              *** added 3-Dec-91 DAL -- prompt for boot disk if needed
0671 15A5 22 A8 00 E1           _GetSysPrefsGS oldPrefs 
0672 15AF AF 50 1B 02           lda   >oldPrefs+2
0673 15B3 29 FF 5F              and   #$5fff                   ;keep the reserved bits and the Cancel state
0674 15B6 09 00 80              ora   #$8000                   ;turn on Use Volume Mount Dialog
0675 15B9 8F 54 1B 02           sta   >myPrefs+2
0676 15BD 22 A8 00 E1           _SetSysPrefsGS myPrefs 
0677 15C7              *** end 3-Dec-91
0678 15C7
0679 15C7 A5 11                 lda   <TheToolNumber           ; line added 18-Nov-90 DAL
0680 15C9
0681 15C9 C9 11 00              cmp   #17                      ; the loader is never loaded
0682 15CC F0 4C                 beq   DoNotLoad                ; from disk
0683 15CE
0684 15CE              ;---------------------------------------------------
0685 15CE              ;
0686 15CE              ; Try Restart, just in case it is already in 
0687 15CE              ; memory.
0688 15CE              ;
0689 15CE
0690 15CE A5 11                 lda   TheToolNumber
0691 15D0 20 DC 1C              jsr   MakeIDNum
0692 15D3
0693 15D3 DA                    phx                            ; space for zp segment size
0694 15D4 DA                    phx                            ; space for zp segment starting address
0695 15D5 DA                    phx                            ; space for starting address
0696 15D6 DA                    phx   
0697 15D7 DA                    phx                            ; make space for returning user id
0698 15D8 48                    pha                            ; push the id of the tool
0699 15D9 A2 11 0A 22           _RESTART 
0700 15E0 90 23                 bcc   SkipInitialLoad
0701 15E2
0702 15E2 68                    pla                            ; clear off junk id
0703 15E3 68                    pla                            ; clear off junk starting addr
0704 15E4 68                    pla   
0705 15E5 68                    pla                            ; clear off junk zp seg
0706 15E6 68                    pla                            ; clear off junk zp size
0707 15E7
0708 15E7              ;---------------------------------------------------
0709 15E7              ;
0710 15E7              ; Restart failed, so make pathname of tool to load
0711 15E7              ;
0712 15E7
0713 15E7 20 AA 1B              jsr   MakeToolPath             ; make tool path uses ts num in a-reg
0714 15EA B0 31                 bcs   LoadError
0715 15EC
0716 15EC              ;---------------------------------------------------
0717 15EC              ;
0718 15EC              ; First look at the SpecialFlag.  If it is clear
0719 15EC              ; then don't try to load outside of special memory
0720 15EC              ; (we already know that it won't work).
0721 15EC              ;
0722 15EC A6 0D                 ldx   TheSpecialFlag
0723 15EE F0 0E                 beq   TooSmall
0724 15F0 20 56 1B              jsr   DoInitialLoad            ; load into non special memory
0725 15F3 90 15                 bcc   LoadOK
0726 15F5 C9 01 02              cmp   #MemFullError
0727 15F8 D0 23                 bne   LoadError
0728 15FA 64 0D                 stz   TheSpecialFlag           ; don't try this again
0729 15FC A6 0D                 ldx   TheSpecialFlag
0730 15FE 20 56 1B     TooSmall jsr   DoInitialLoad
0731 1601 B0 1A                 bcs   LoadError
0732 1603 90 05                 bcc   LoadOK
0733 1605
0734 1605              ;---------------------------------------------------
0735 1605              ;
0736 1605              ; Restart was successful, make stack look same
0737 1605              ; as if called DoInitialLoad.
0738 1605              ;
0739 1605 68           SkipInitialLoad pla                     ; don't need user id
0740 1606 FA                    plx                            ; need starting addr
0741 1607 7A                    ply   
0742 1608 68                    pla                            ; don't need zp adr
0743 1609 68                    pla                            ; don't need zp size
0744 160A
0745 160A              LoadOK    
0746 160A
0747 160A
0748 160A              ;---------------------------------------------------
0749 160A              ;
0750 160A              ; Install the tool
0751 160A              ;
0752 160A F4 00 00              PushWord #0                    ; System Flag
0753 160D D4 11                 pei   TheToolNumber            ; Tool number
0754 160F 5A                    phy                            ; Table Address
0755 1610 DA                    phx   
0756 1611 A2 01 0A 22           _SetTSPtr 
0757 1618 B0 03                 bcs   InstallError
0758 161A
0759 161A
0760 161A 20 76 1B     DoNotLoad jsr   CheckVersion            ; any error will be in a-reg
0761 161D
0762 161D              ;---------------------------------------------------
0763 161D              ;
0764 161D              ; Copy the final value for SpecialFlag from to
0765 161D              ; result word, and clean up the stack.
0766 161D
0767 161D              LoadError  
0768 161D              InstallError  
0769 161D
0770 161D              *** added 3-Dec-91 DAL -- restore OS preferences
0771 161D 48                    pha                            ;save error code
0772 161E 22 A8 00 E1           _SetSysPrefsGS oldPrefs 
0773 1628 68                    pla                            ;retrieve error code
0774 1629              *** end 3-Dec-91
0775 1629
0776 1629 A6 0D        FastExit ldx   TheSpecialFlag
0777 162B 86 13                 stx   ResultSpecialFlag
0778 162D
0779 162D 48                    pha                            ; save the error code
0780 162E A5 01                 lda   PathHandle
0781 1630 05 03                 ora   PathHandle+2
0782 1632 F0 0B                 beq   NoHandle
0783 1634 D4 03                 pei   Pathhandle+2
0784 1636 D4 01                 pei   Pathhandle
0785 1638 A2 02 10 22           _DisposeHandle 
0786 163F
0787 163F 68           NoHandle pla                            ; get error code
0788 1640
0789 1640 FA                    plx                            ; strip off 4 words of local vars
0790 1641 FA                    plx   
0791 1642 FA                    plx   
0792 1643 FA                    plx   
0793 1644 2B                    pld                            ; restore direct page
0794 1645 7A                    ply                            ; get rts adr in y-reg for momment
0795 1646 FA                    plx                            ; pull 3 input words off stack
0796 1647 FA                    plx   
0797 1648 FA                    plx   
0798 1649 5A                    phy                            ; put rts adr back on stack
0799 164A
0800 164A C9 01 00              cmp   #1                       ; set carry based on error code
0801 164D 60                    rts   
0802 164E
0803 164E              *** added 3-Dec-91 DAL
0804 164E 01 00        oldPrefs DC W:1                         ;1 parameter
0805 1650 00 00                 DC W:0                         ;the old SysPrefs
0806 1652
0807 1652 01 00        myPrefs  DC W:1
0808 1654 00 00                 DC W:0                         ;my modified preferences
0809 1656              *** end 3-Dec-91
0810 1656
0811 1656              ;---------------------------------------------------
0812 1656              ;
0813 1656              ; Local routine to handle making the intial load
0814 1656              ; call.
0815 1656              ;
0816 1656              ; Inputs:
0817 1656              ;    TheToolNumber
0818 1656              ;    TheSpecialFlag
0819 1656              ;
0820 1656              ; Outputs:
0821 1656              ;    x-reg   Low word of address of tool
0822 1656              ;    y-reg   High word of address of tool
0823 1656              ;    a-reg   Error code from InitialLoad call
0824 1656              ;    carry   set if error, clear if none.
0825 1656              ;
0826 1656              ;
0827 1656 A5 11        DoInitialLoad lda   TheToolNumber       ; get ID num back
0828 1658 20 DC 1C              jsr   MakeIDNum
0829 165B DA                    phx                            ; space for zp segment size
0830 165C DA                    phx                            ; space for zp segment starting address
0831 165D DA                    phx                            ; space for starting address
0832 165E DA                    phx   
0833 165F DA                    phx                            ; space for userid
0834 1660 48                    pha                            ; Push the Tools userID
0835 1661 D4 07                 pei   PathPtr+2                ; Push pointer to the path name
0836 1663 D4 05                 pei   PathPtr
0837 1665 D4 0D                 pei   TheSpecialFlag           ; special memory flag
0838 1667 A2 11 09 22           _InitialLoad 
0839 166E 83 09                 sta   9,s                      ; save any error over zp size on stack
0840 1670 68                    pla                            ; don't need user id
0841 1671 FA                    plx                            ; need starting addr in x,y
0842 1672 7A                    ply   
0843 1673 68                    pla                            ; don't need zp adr
0844 1674 68                    pla                            ; put error (if any back in a-reg)
0845 1675
0846 1675 60                    rts   
0847 1676
0848 1676
0849 1676              **********************************************************************************
0850 1676              *
0851 1676              * CheckVersion
0852 1676              * 18-Nov-90 DAL
0853 1676              *
0854 1676              * Inputs:  TheToolNumber, TheMinVersion
0855 1676              *
0856 1676              * Output:  carry flag = clear if we're okay
0857 1676              *          A = error code
0858 1676              *
0859 1676              * Version Number format:
0860 1676              *
0861 1676              *  ---------------------------------
0862 1676              *  |P|f|f|f|m|m|m|m|v|v|v|v|v|v|v|v|
0863 1676              *  ---------------------------------
0864 1676              *      P = prototype bit
0865 1676              *      f = flag bits
0866 1676              *      m = major version
0867 1676              *      v = minor version
0868 1676              *
0869 1676              * The Prototype bit is ignored in version comparisons.
0870 1676              *
0871 1676              * The Flag bits are handled specially.  If you don't
0872 1676              * ask for a given flag, it doesn't affect the comparison
0873 1676              * at all.  But if you ask for one, it's required in the
0874 1676              * actual version.
0875 1676              *
0876 1676 48           CheckVersion pha                        ; space for version call result
0877 1677 A5 11                 lda   TheToolNumber            ; get tool number and make into
0878 1679 09 00 04              ora   #$0400                   ; version call
0879 167C AA                    tax   
0880 167D 22 00 00 E1           jsl   $E10000                  ; (this will be RealVersion)
0881 1681 90 02                 bcc   @1
0882 1683 FA                    plx                            ;pull result space
0883 1684 60                    rts   
0884 1685
0885 1685 68           @1       pla   
0886 1686 A8                    tay                            ;Y=copy of real version
0887 1687 29 00 70              and   #$7000
0888 168A 49 00 70              eor   #$7000                   ;Which flag bits are actually off?
0889 168D 25 0F                 and   <TheMinVersion           ;Did we need any of them?
0890 168F D0 0F                 bne   @VersionError            ;Oops, we did.
0891 1691
0892 1691 A5 0F                 lda   <TheMinVersion
0893 1693 29 FF 0F              and   #$0fff
0894 1696 48                    pha   
0895 1697 98                    tya                            ;Get real tool version back
0896 1698 29 FF 0F              and   #$0fff                   ;check major and minor versions
0897 169B C3 01                 cmp   1,s
0898 169D 68                    pla   
0899 169E B0 05                 bcs   @AllIsWell               ;Version is at least equal to MinVersion
0900 16A0
0901 16A0 A9 10 01     @VersionError lda   #BadVersionNum
0902 16A3 38                    sec   
0903 16A4 60                    rts   
0904 16A5
0905 16A5 A9 00 00     @AllIsWell lda   #0                     ; No Error
0906 16A8 18                    clc   
0907 16A9 60                    rts   
0908 16AA
0909 16AA              ;---------------------------------------------------
0910 16AA              ;
0911 16AA              ; MakeToolPath
0912 16AA              ;
0913 16AA              ; 1.  Gets memory to hold a pathname.  Handle
0914 16AA              ;     is put into PathHandle, and derefed into
0915 16AA              ;     PathPtr.
0916 16AA              ; 2.  Creates the path in PathHandle
0917 16AA              ;
0918 16AA              ;
0919 16AA              MakeToolPath  
0920 16AA
0921 16AA              ;---------------------------------------------------
0922 16AA              ;
0923 16AA              ; First get memory and deref the handle.
0924 16AA              ;
0925 16AA A9 17 00              lda   #PathSize
0926 16AD A2 00 80              ldx   #attrLocked
0927 16B0 20 EA 1C              jsr   TLGetMem
0928 16B3 90 01                 bcc   GotIt
0929 16B5 60                    rts   
0930 16B6
0931 16B6 85 01        GotIt    sta   PathHandle
0932 16B8 86 03                 stx   PathHandle+2
0933 16BA A7 01                 lda   [PathHandle]
0934 16BC 85 05                 sta   PathPtr
0935 16BE A0 02 00              ldy   #2
0936 16C1 B7 01                 lda   [PathHandle],y
0937 16C3 85 07                 sta   PathPtr+2
0938 16C5
0939 16C5
0940 16C5              ;---------------------------------------------------
0941 16C5              ;
0942 16C5              ; Now copy the first part of the path name into
0943 16C5              ; the memory we've obtained.
0944 16C5              ;
0945 16C5 8B                    phb                            ; set bank to this code bank
0946 16C6 4B                    phk   
0947 16C7 AB                    plb   
0948 16C8
0949 16C8 E2 30                 sep   #$30                     ; switch to 8 bit mode
0950 16CA                       longa off
0951 16CA                       longi off
0952 16CA
0953 16CA A0 16                 ldy   #PathSize-1              ; move the string
0954 16CC B9 11 1C     MoveLoop lda   |ToolPath,y
0955 16CF 97 05                 sta   [PathPtr],y
0956 16D1 88                    dey   
0957 16D2 10 F8                 bpl   MoveLoop
0958 16D4
0959 16D4 C2 30                 rep   #$30                     ; back to full native
0960 16D6                       longa on
0961 16D6                       longi on
0962 16D6
0963 16D6 AB                    plb                            ; restore dbr.
0964 16D7
0965 16D7              ;---------------------------------------------------
0966 16D7              ;
0967 16D7              ; Finish up the path name by converting the tool
0968 16D7              ; number into ascii characters at the end of the
0969 16D7              ; path name.
0970 16D7
0971 16D7 D4 11                 pei   TheToolNumber            ; push the int
0972 16D9 A5 05                 lda   PathPtr
0973 16DB 18                    clc   
0974 16DC 69 14 00              adc   #o_OutChars
0975 16DF AA                    tax   
0976 16E0 A5 07                 lda   PathPtr+2
0977 16E2 90 01                 bcc   NoCarry
0978 16E4 1A                    inc   a
0979 16E5 48           NoCarry  pha   
0980 16E6 DA                    phx   
0981 16E7 F4 03 00              PushWord #3                    ; 3 character output
0982 16EA F4 00 00              PushWord #0                    ; unsigned
0983 16ED A2 0B 26 22           _Int2Dec 
0984 16F4
0985 16F4              ;---------------------------------------------------
0986 16F4              ;
0987 16F4              ; Fix the path string so that any blanks left
0988 16F4              ; by _Int2Dec are converted to zeros.
0989 16F4              ;
0990 16F4 E2 30                 sep   #$30
0991 16F6                       longa off
0992 16F6                       longi off
0993 16F6 A0 14                 ldy   #o_OutChars
0994 16F8 B7 05                 lda   [PathPtr],y
0995 16FA C9 20                 cmp   #' '
0996 16FC D0 0F                 bne   NoMoreBlanks
0997 16FE A9 30                 lda   #'0'
0998 1700 97 05                 sta   [PathPtr],y
0999 1702 C8                    iny   
1000 1703 B7 05                 lda   [PathPtr],y
1001 1705 C9 20                 cmp   #' '
1002 1707 D0 04                 bne   NoMoreBlanks
1003 1709 A9 30                 lda   #'0'
1004 170B 97 05                 sta   [PathPtr],y
1005 170D
1006 170D C2 30        NoMoreBlanks rep   #$30
1007 170F                       longa on
1008 170F                       longi on
1009 170F
1010 170F 18                    clc                            ; signal no error
1011 1710
1012 1710 60                    rts   
1013 1711
1014 1711
1015 1711 16           ToolPath DC B:PathLength
1016 1712 2A 2F 53 79  StartChars DC B:'*/system/tools/tool'
1017 1725              o_OutChars equ   *-ToolPath
1018 1725              PathLength equ   *-StartChars+3
1019 1725
1020 1725              PathSize equ   PathLength+1
1021 1725
1022 1725                       ENDP 
1023 1725
1024 1725
1025 1725
1026 1725                       title 'UnloadTools' 
1027 1725              ****************************************************************
1028 1725              *
1029 1725              UnloadTools PROC EXPORT 
1030 1725              *
1031 1725              * The Default TPT is restored.  Any tools that are active 
1032 1725              * but not part installed in the default TPT are made into
1033 1725              * zombies.
1034 1725              *
1035 1725              *
1036 1725              *
1037 1725              * Inputs:
1038 1725              *                   none
1039 1725              *
1040 1725              * Outputs:
1041 1725              *                   none
1042 1725              *
1043 1725              * External Refs:
1044 1725                       import MakeIDNum 
1045 1725                       import DummyTable 
1046 1725              *
1047 1725              * Entry Points:
1048 1725                       ENTRY UnloadThisTool 
1049 1725                       ENTRY SetupForUnload 
1050 1725                       ENTRY CleanupForUnload 
1051 1725              *
1052 1725                       longa on                       ; mode
1053 1725                       longi on
1054 1725              *
1055 1725              * Change History
1056 1725              *
1057 1725              * 05 Oct 87    Steven Glass
1058 1725              *
1059 1725              *    No changes were need to make this run in ROM.
1060 1725              *    However, many chnages were made to this routine because
1061 1725              *    we changed the UnloadTools algorithm.
1062 1725              *
1063 1725              *    In the original version of this routine, all tools not
1064 1725              *    in the original rom (1-13) except the loader (17) were
1065 1725              *    unloaded.  That is a user shutdown call was made on 
1066 1725              *    them to put them in zombie state and a dummy call table
1067 1725              *    was installed.
1068 1725              *
1069 1725              *    In this version we do a little more work.  The idea here
1070 1725              *    is to restore the "default" TPT.  
1071 1725              *
1072 1725              * 14 Oct 87    Steven Glass
1073 1725              *
1074 1725              * The loader (tool 17) is never unloaded.
1075 1725              *
1076 1725              *
1077 1725              * 15 Mar 89         Steven Glass
1078 1725              *
1079 1725              * _UserShutdown returns some undocumented errors that can
1080 1725              * really cause trouble so we just now ignore all errors.
1081 1725              *
1082 1725              * 07 Apr 89         Steven Glass
1083 1725              *
1084 1725              * Added range check to UnloadThisTool so that DummyTable would
1085 1725              * not be stored beyond the end of the real tpt if an unload call is
1086 1725              * made for a tool not in the defaultTPT.
1087 1725              *
1088 1725              ****************************************************************
1089 1725
1090 1725
1091 1725
1092 1725                       DefineStack 
1093 1725              OrigD    word 
1094 1725              RealTPT  long 
1095 1725              DefaultTPT long 
1096 1725              Counter  word 
1097 1725
1098 1725
1099 1725              ;---------------------------------------------------
1100 1725              ;
1101 1725              ; Set things up.
1102 1725              ;
1103 1725
1104 1725 20 A3 1C              jsr   SetupforUnload           ; set up direct page
1105 1728
1106 1728
1107 1728 A9 01 00              lda   #1                       ; init the counter
1108 172B 85 0B                 sta   Counter
1109 172D
1110 172D              ;---------------------------------------------------
1111 172D              ;
1112 172D              ; Loop through each tool installed.
1113 172D              ;
1114 172D
1115 172D              Loop                                    ; 
1116 172D A5 0B                 lda   Counter                  ; Check to see if we are done.
1117 172F C7 03                 cmp   [RealTPT]
1118 1731 B0 07                 bcs   Done
1119 1733
1120 1733 20 44 1C              jsr   UnloadThisTool           ; no so unload this one
1121 1736
1122 1736 E6 0B                 inc   counter                  ; bump the counter
1123 1738 80 F3                 bra   Loop
1124 173A
1125 173A              Done      
1126 173A
1127 173A              ;---------------------------------------------------
1128 173A              ;
1129 173A              ; Update the count in the real table from the
1130 173A              ; default table.  Note that the default TPT may
1131 173A              ; never be bigger than the real TPT.
1132 173A              ;
1133 173A A0 00 00              ldy   #0
1134 173D 20 D1 1C              jsr   MoveToReal
1135 1740
1136 1740
1137 1740              ;---------------------------------------------------
1138 1740              ;
1139 1740              ; Clean things up.
1140 1740              ;
1141 1740
1142 1740 20 C8 1C              jsr   CleanupForUnload
1143 1743
1144 1743 60                    rts   
1145 1744
1146 1744
1147 1744              ;---------------------------------------------------
1148 1744              ;
1149 1744              ; UnloadThisTool
1150 1744              ;
1151 1744              ; Input
1152 1744              ;    Counter  ToolNumber
1153 1744              ;
1154 1744              ; This is the routine that does the work for each
1155 1744              ; tool to be unloaded.
1156 1744              ;
1157 1744              UnloadThisTool  
1158 1744
1159 1744 A5 0B                 lda   Counter
1160 1746
1161 1746 C9 11 00              cmp   #17                      ; is it the loader?
1162 1749 D0 01                 bne   continue                 ; No, so go on
1163 174B 60                    rts                            ; never unload the loader.
1164 174C
1165 174C C7 07        continue cmp   [DefaultTPT]             ; is it in the default table?
1166 174E 90 18                 bcc   InDefaultTable
1167 1750
1168 1750
1169 1750              ;
1170 1750              ; See if the tool is in the real table.  07 Apr 89  SEG
1171 1750              ;
1172 1750              ; 4/6/90	Mensch
1173 1750              ; Fixed instruction below, was [RealTPT],y ....
1174 1750              ;
1175 1750 C7 03                 cmp   [RealTPT]
1176 1752 90 01                 bcc   ItsIn
1177 1754
1178 1754 60                    rts   
1179 1755
1180 1755
1181 1755              ItsIn     
1182 1755              ;---------------------------------------------------
1183 1755              ;
1184 1755              ; This tool is not in the default table so 
1185 1755              ; install the dummy table into the real TPT
1186 1755              ;
1187 1755 A5 0B                 lda   Counter
1188 1757 0A                    asl   a
1189 1758 0A                    asl   a
1190 1759 A8                    tay   
1191 175A
1192 175A A9 E3 1C              lda   #DummyTable
1193 175D 97 03                 sta   [RealTPT],y
1194 175F A9 02 00              lda   #^DummyTable
1195 1762 C8                    iny   
1196 1763 C8                    iny   
1197 1764 97 03                 sta   [RealTPT],y
1198 1766 80 1F                 bra   ShutItDown
1199 1768
1200 1768
1201 1768              ;---------------------------------------------------
1202 1768              ;
1203 1768              ; This tool is in the default table.  If it is 
1204 1768              ; pointer is not the same in the real and the default
1205 1768              ; then copy from default to real and shut the tool
1206 1768              ; down.
1207 1768              ;
1208 1768 A5 0B        InDefaultTable lda   Counter
1209 176A 0A                    asl   a
1210 176B 0A                    asl   a
1211 176C A8                    tay   
1212 176D B7 07                 lda   [DefaultTPT],y
1213 176F D7 03                 cmp   [RealTPT],y
1214 1771 D0 0C                 bne   Adjust
1215 1773 C8                    iny   
1216 1774 C8                    iny   
1217 1775 B7 07                 lda   [DefaultTPT],y
1218 1777 D7 03                 cmp   [RealTPT],y
1219 1779 D0 04                 bne   Adjust
1220 177B
1221 177B A9 00 00              lda   #0                       ;no error (added 26-Nov-90 DAL)
1222 177E
1223 177E 60                    rts   
1224 177F
1225 177F A5 0B        Adjust   lda   Counter                  ; use counter to create table
1226 1781 0A                    asl   a                        ; offset used as input to 
1227 1782 0A                    asl   a                        ; movetoreal.
1228 1783 A8                    tay   
1229 1784 20 D1 1C              jsr   MoveToReal
1230 1787
1231 1787              ShutItDown                              ; 
1232 1787              ; If the OS_Kind is not P16 then we skip this part.
1233 1787 AF BC 00 E1           lda   >OS_Kind
1234 178B 29 01 00              and   #$0001
1235 178E F0 12                 beq   SkipShutDown
1236 1790
1237 1790 48                    pha                            ; space for result
1238 1791 A5 0B                 lda   Counter
1239 1793 20 DC 1C              jsr   MakeIDNum
1240 1796 48                    pha                            ; ID to shut down
1241 1797 F4 00 40              PushWord #$4000                ; leave me in memory as a ZOMBIE
1242 179A A2 11 12 22           _UserShutdown                  ; ignore errors
1243 17A1
1244 17A1 FA                    plx                            ; clear stack from user shutdown call
1245 17A2
1246 17A2 60           SkipShutDown rts   
1247 17A3
1248 17A3
1249 17A3
1250 17A3
1251 17A3              ;---------------------------------------------------
1252 17A3              ;
1253 17A3              ; SetupForUnload
1254 17A3              ;
1255 17A3              ; Routine to setup stack and d-page for unloading 
1256 17A3              ; tools.  Must be ballenced by a CleanupForUnload
1257 17A3              ; call.
1258 17A3              ;
1259 17A3              ; Note that the a-reg is preserved by this routine.
1260 17A3              ;
1261 17A3
1262 17A3              SetupForUnload                          ; 
1263 17A3 FA                    plx                            ; get rts adr in x.
1264 17A4 A8                    tay                            ; preserve the a-reg
1265 17A5 48                    pha   
1266 17A6 48                    pha   
1267 17A7 48                    pha   
1268 17A8 48                    pha   
1269 17A9 48                    pha   
1270 17AA 0B                    phd   
1271 17AB
1272 17AB 3B                    tsc   
1273 17AC 5B                    tcd   
1274 17AD
1275 17AD AF C0 03 E1           lda   >TPTPtr
1276 17B1 85 03                 sta   RealTPT
1277 17B3 AF C2 03 E1           lda   >TPTPtr+2
1278 17B7 85 05                 sta   RealTPT+2
1279 17B9
1280 17B9 AF 88 01 E1           lda   >DefaultTPTPtr
1281 17BD 85 07                 sta   DefaultTPT
1282 17BF AF 8A 01 E1           lda   >DefaultTPTPtr+2
1283 17C3 85 09                 sta   DefaultTPT+2
1284 17C5
1285 17C5 DA                    phx                            ; put rts adr back.
1286 17C6 98                    tya   
1287 17C7 60                    rts   
1288 17C8
1289 17C8
1290 17C8              ;---------------------------------------------------
1291 17C8              ;
1292 17C8              ; CleanupForUnload
1293 17C8              ;
1294 17C8              ; Cleans up the stack and d-page after unload calls.
1295 17C8              ; Must follow a SetupForUnload call.
1296 17C8              ; 
1297 17C8              ; Preserves the a-reg.
1298 17C8              ;
1299 17C8
1300 17C8 FA           CleanupForUnload plx   
1301 17C9 2B                    pld   
1302 17CA 7A                    ply   
1303 17CB 7A                    ply   
1304 17CC 7A                    ply   
1305 17CD 7A                    ply   
1306 17CE 7A                    ply   
1307 17CF DA                    phx   
1308 17D0 60                    rts   
1309 17D1
1310 17D1
1311 17D1              ;---------------------------------------------------
1312 17D1              ;
1313 17D1              ; MoveToReal
1314 17D1              ;
1315 17D1              ; Copies 4 bytes from the DefaultTPT to the RealTPT
1316 17D1              ; starting from the byte indicated by the y-reg.
1317 17D1              ;
1318 17D1 B7 07        MoveToReal lda   [DefaultTPT],y
1319 17D3 97 03                 sta   [RealTPT],y
1320 17D5 C8                    iny   
1321 17D6 C8                    iny   
1322 17D7 B7 07                 lda   [DefaultTPT],y
1323 17D9 97 03                 sta   [RealTPT],y
1324 17DB 60                    rts   
1325 17DC
1326 17DC                       ENDP 
1327 17DC
1328 17DC
1329 17DC
1330 17DC              ****************************************************************
1331 17DC              *
1332 17DC              MakeIDNum PROC 
1333 17DC              *
1334 17DC              * Using the tool number in the a-register, return a
1335 17DC              * UserID for the Loader to use for the tool.
1336 17DC              *
1337 17DC              *
1338 17DC              * Inputs:
1339 17DC              *	a-reg : tool num
1340 17DC              *
1341 17DC              * Outputs:
1342 17DC              *	a-reg : UserID for tool.
1343 17DC              *
1344 17DC              * External Refs:
1345 17DC              *	none
1346 17DC              *
1347 17DC              * Entry Points:
1348 17DC              *	none
1349 17DC              *
1350 17DC                       longa on                       ; mode
1351 17DC                       longi on
1352 17DC              *
1353 17DC              * Change History
1354 17DC              *
1355 17DC              * 05 Oct 87    Steven Glass
1356 17DC              *
1357 17DC              *    No changes were needed to make this run in ROM.
1358 17DC              *
1359 17DC              ****************************************************************
1360 17DC
1361 17DC 29 FF 00              and   #$00FF                   ; mask off high word
1362 17DF 09 00 40              ora   #$4000                   ; or in word for tools
1363 17E2 60                    rts   
1364 17E3                       ENDP 
1365 17E3
1366 17E3
1367 17E3                       END   
